package GUI;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintStream;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import doABC.MethodBodyInfo;
import about.About;
import jhe.hexed.JHexEditor;
import FlashReader.AbcFile;
import FlashReader.DoABC;
import FlashReader.Header;
import FlashReader.SWF;
import FlashReader.Tag;
import GUI.doABC.GUI_class_info;
import GUI.doABC.GUI_cpool_info;
import GUI.doABC.GUI_exception_info;
import GUI.doABC.GUI_instance_info;
import GUI.doABC.GUI_method_body_info;
import GUI.doABC.GUI_method_info;
import GUI.doABC.GUI_names;
import GUI.doABC.GUI_script_info;
import GUI.GUI_Encryptor;
import Main.Main;

public class GUIswfReader {
	
	public JFrame frame;
	public GUI_wczytywanie gw;
	public GUIswfReader gui;
	
	private SWF swf;
	private String appName = "Swf Reader 1.2.2 www.konkursy-hack.pl konkursy-hack.na11.pl";
	private JMenuItem secureSWF_mi;
	private JMenuItem autor_mi;
	private JMenuItem instance_mi;
	private JMenuItem class_mi;
	private JMenuItem script_mi;
	private JMenuItem methodBody_mi;
	private JMenuItem cpool_mi;
	private JMenu extraMenu_m;
	private JMenu doabcMenu_m;
	private JButton hexview_bt;
	private JButton czytajDoabc_bt;
	private JButton czytajSwf_bt;
	private JButton odswiez_bt;
	private JTextArea console_tf;
	private JTextArea tags_ta;
	private JComboBox doABC_cb;
	private JTextField framerate_tf;
	private JTextField framecount_tf;
	private JTextField ymax_tf;
	private JTextField ymin_tf;
	private JTextField xmax_tf;
	private JTextField xmin_tf;
	private JTextField rozmiar_tf;
	private JTextField wersja_tf;
	private JProgressBar progressBar;
	private TreeView tree_tv;
	private JDesktopPane desktopPane;

	public GUIswfReader(SWF swf) {
		this.swf=swf;
		createContents();
	}


	/**
	 * Initialize the contents of the frame
	 */
	private void createContents() {
		
		final JFrame frame = new JFrame();
		final JFileChooser fc = new JFileChooser();
		final JMenuBar menuBar = new JMenuBar();
		final JFileChooser fc2 = new JFileChooser();
		final JMenu plikMenu_m = new JMenu();
		final JMenuItem open_mi = new JMenuItem();
		final JMenuItem saveAs_mi = new JMenuItem();
		final JMenu edycjaMenu_m = new JMenu();
		final JMenuItem method_mi = new JMenuItem();
		
		script_mi = new JMenuItem();
		czytajDoabc_bt = new JButton();
		czytajSwf_bt = new JButton();
		methodBody_mi = new JMenuItem();
		desktopPane = new JDesktopPane();
		instance_mi = new JMenuItem();
		console_tf = new JTextArea();
		odswiez_bt = new JButton();
		autor_mi = new JMenuItem();
		autor_mi.setOpaque(false);
		doabcMenu_m = new JMenu();
		cpool_mi = new JMenuItem();	
		
		menuBar.add(plikMenu_m);
		plikMenu_m.setText("Plik");
		plikMenu_m.setText(SWF.msgs.getString("file"));
		
		plikMenu_m.add(open_mi);
		open_mi.setText("Wczytaj");
		open_mi.setText(SWF.msgs.getString("open"));

		plikMenu_m.add(saveAs_mi);
		saveAs_mi.setText("Zapisz jako");
		saveAs_mi.setText(SWF.msgs.getString("saveAs"));
		
		menuBar.add(edycjaMenu_m);
		edycjaMenu_m.setText("Edycja");
		edycjaMenu_m.setText(SWF.msgs.getString("edit"));
		
	
		doabcMenu_m.setText("doABC");
		edycjaMenu_m.add(doabcMenu_m);
		

		
		
		open_mi.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent arg0) {
				fc.showOpenDialog(getFrame());
			}
		});

		saveAs_mi.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent arg0) {
				System.out.println("generateDoABC()");
				fc2.showSaveDialog(getFrame());
				
			}
		});

		
		setFrame(frame);
		getFrame().setTitle(appName);
		getFrame().setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		desktopPane.setOpaque(false);
		getFrame().setContentPane(desktopPane);
		
		//Menu bar
		getFrame().setJMenuBar(menuBar);
		

		
		extraMenu_m = new JMenu();
		extraMenu_m.setText("Extra");
		menuBar.add(extraMenu_m);
		
		autor_mi.setMaximumSize(new Dimension(70, 70));
		autor_mi.setText("Autor");
		autor_mi.setText(SWF.msgs.getString("about"));
		menuBar.add(autor_mi);


		
		
		fc.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    //Handle open button action.
		    if (e.getSource() == fc) {
		    	String returnVal = e.getActionCommand();
		    	if (returnVal.equals(JFileChooser.APPROVE_SELECTION)) {
		    		clear();
		    		File file = fc.getSelectedFile();
		    		showInfo(SWF.msgs.getString("chooseFile"));
		    		swf.readSwf(file);
		    		czytajSwf_bt.setEnabled(true);
		    		czytajDoabc_bt.setEnabled(false);
		    		hexview_bt.setEnabled(true);
		    		Main.status = Main.Statusy.JEST_PLIK;
		    		getFrame().setTitle(appName + " " + file.getPath());
		    		showInfo(SWF.msgs.getString("ok"));
		    	}else{
		    		czytajSwf_bt.setEnabled(false);
		    	}
		   } 
		}
		});

		fc2.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
			    //Handle open button action.
			    if (e.getSource() == fc2) {
			    	String returnVal = e.getActionCommand();
			    	if (returnVal.equals(JFileChooser.APPROVE_SELECTION)) {

			    		Object[] possibilities = {"0", "1", "2","3","4","5","6","7","8","9"};
			    		String s = (String)JOptionPane.showInputDialog(
			    		                    frame,
			    		                    SWF.msgs.getString("Icompress"),
			    		                    SWF.msgs.getString("compress"),
			    		                    JOptionPane.PLAIN_MESSAGE,
			    		                    null,
			    		                    possibilities,
			    		                    "ham");

			    		File file = fc2.getSelectedFile();
			    		swf.zapiszSWF(file, Integer.parseInt(s));
			    		showInfo(SWF.msgs.getString("ok"));
			    	}
			   } 
			}
			});
		
		
		cpool_mi.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {

					EventQueue.invokeLater(new Runnable() {
						public void run() {
							try {
								AbcFile abc = ((DoABC)Main.choosedTag).getAbcData();
								GUI_cpool_info frame = new GUI_cpool_info(abc.getConstant_pool(),getThis());
								getThis().frame.getContentPane().add(frame);
								frame.setVisible(true);
								frame.toFront();
	
							} catch (Exception e) {
								e.printStackTrace();
							}
						}
					});
				
			}
		});
		cpool_mi.setText("Cpool_info");
		doabcMenu_m.add(cpool_mi);

		doabcMenu_m.add(method_mi);
		method_mi.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent arg0) {
				
					EventQueue.invokeLater(new Runnable() {
						public void run() {
							try {
								
								GUI_method_info frame = new GUI_method_info(swf);
								getThis().frame.getContentPane().add(frame);
								frame.setVisible(true);
								frame.toFront();
	
							} catch (Exception e) {
								e.printStackTrace();
							}
						}
					});
				
			
				
				
				
				
			}
		});
		method_mi.setText("Method_info");
		doabcMenu_m.add(instance_mi);
		instance_mi.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent arg0) {

			
					EventQueue.invokeLater(new Runnable() {
						public void run() {
							try {
								
								GUI_instance_info frame = new GUI_instance_info(swf,getThis());
								getThis().frame.getContentPane().add(frame);
								frame.setVisible(true);
								frame.toFront();
	
							} catch (Exception e) {
								e.printStackTrace();
							}
						}
					});
				
				
			}
		});
		instance_mi.setText("Instance_info");
		class_mi = new JMenuItem();
		doabcMenu_m.add(class_mi);
		class_mi.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				
				
					EventQueue.invokeLater(new Runnable() {
						public void run() {
							try {
								
								GUI_class_info frame = new GUI_class_info(swf,getThis());
								getThis().frame.getContentPane().add(frame);
								frame.setVisible(true);
								frame.toFront();
	
							} catch (Exception e) {
								e.printStackTrace();
							}
						}
					});
				
				
			}
		});
		class_mi.setText("Class_info");
		doabcMenu_m.add(script_mi);
		script_mi.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent arg0) {
				
					EventQueue.invokeLater(new Runnable() {
						public void run() {
							try {
								
								GUI_script_info frame = new GUI_script_info(swf,getThis());
								getThis().frame.getContentPane().add(frame);
								frame.setVisible(true);
								frame.toFront();
	
							} catch (Exception e) {
								e.printStackTrace();
							}
						}
					});
				
				
				
				
			}
		});
		script_mi.setText("Script_info");
		doabcMenu_m.add(methodBody_mi);
		methodBody_mi.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent arg0) {
				
					EventQueue.invokeLater(new Runnable() {
						public void run() {
							try {
								
								GUI_method_body_info frame = new GUI_method_body_info(getThis(),swf);
								getThis().frame.getContentPane().add(frame);
								frame.setVisible(true);
								frame.toFront();
	
							} catch (Exception e) {
								e.printStackTrace();
							}
						}
					});
				
				
			}
		});
		methodBody_mi.setText("Method_body_info");

		final JMenuItem tags_m = new JMenuItem();
		tags_m.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent arg0) {
				EventQueue.invokeLater(new Runnable() {
					public void run() {
						try {
							
							GUI_Tag frame = new GUI_Tag(swf,getThis());
							getThis().frame.getContentPane().add(frame);
							frame.setVisible(true);
							frame.toFront();

						} catch (Exception e) {
							e.printStackTrace();
						}
					}
				});
			}
		});
		tags_m.setText("Tags");
		edycjaMenu_m.add(tags_m);

		secureSWF_mi = new JMenuItem();
		secureSWF_mi.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent arg0) {
				EventQueue.invokeLater(new Runnable() {
					public void run() {
						try {
							
							SecureSWF frame = new SecureSWF(getThis(),swf);
							getThis().frame.getContentPane().add(frame);
							frame.setVisible(true);
							frame.toFront();
								
							
						} catch (Exception e) {
							e.printStackTrace();
						}
					}
				});
			}
		});
		secureSWF_mi.setText("Secure SWF 3.1");
		extraMenu_m.add(secureSWF_mi);
		
		JMenuItem encrypter_mi = new JMenuItem();
		encrypter_mi.setEnabled(false);
		encrypter_mi.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent arg0) {
				EventQueue.invokeLater(new Runnable() {
					public void run() {
						try {
							
							GUI_Encryptor frame  = new GUI_Encryptor((DoABC)Main.choosedTag);
							getThis().frame.getContentPane().add(frame);
							frame.setVisible(true);
							frame.toFront();
							
						} catch (Exception e) {
							e.printStackTrace();
						}
					}
					
				});
			}
		});
		encrypter_mi.setText("Encrypter");
		extraMenu_m.add(encrypter_mi);
		
		
		autor_mi.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				EventQueue.invokeLater(new Runnable() {
					public void run() {
						try {
							
							About frame = new About(getThis());
							getThis().frame.getContentPane().add(frame);
							frame.setVisible(true);
							frame.toFront();

						} catch (Exception e) {
							e.printStackTrace();
						}
					}
				});
			}
		});
		
	

		JLabel tagi_l;
		tagi_l = new JLabel();
		tagi_l.setText("Tagi");
		tagi_l.setText(SWF.msgs.getString("tags"));
		
		JLabel wersja_l;
		wersja_l = new JLabel();
		wersja_l.setText("Wersja:");
		wersja_l.setText(SWF.msgs.getString("version"));
		
		JLabel rozmiar_l;
		rozmiar_l = new JLabel();
		rozmiar_l.setText("Rozmiar:");
		rozmiar_l.setText(SWF.msgs.getString("size"));
		
		JLabel xmin_l;
		xmin_l = new JLabel();
		xmin_l.setText("xMin:");
		
		JLabel xmax_l;
		xmax_l = new JLabel();
		xmax_l.setText("xMax:");

		JLabel ymin_l;
		ymin_l = new JLabel();
		ymin_l.setText("yMin:");

		JLabel ymax_l;
		ymax_l = new JLabel();
		ymax_l.setText("yMax:");

		JLabel framecount_l;
		framecount_l = new JLabel();
		framecount_l.setText("FrameCount:");
		framecount_l.setText(SWF.msgs.getString("frameCount"));

		JLabel framerate_l;
		framerate_l = new JLabel();
		framerate_l.setText("FrameRate:");
		framerate_l.setText(SWF.msgs.getString("frameRate"));
		
		wersja_tf = new JTextField();
		wersja_tf.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				swf.getHeader().setVersion(Integer.parseInt(wersja_tf.getText()));
			}
		});

		rozmiar_tf = new JTextField();
		rozmiar_tf.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				swf.getHeader().setFileLength(Integer.parseInt(rozmiar_tf.getText()));
			}
		});

		xmin_tf = new JTextField();
		xmin_tf.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				swf.getHeader().setXmin(Integer.parseInt(xmin_tf.getText())*20);
			}
		});

		xmax_tf = new JTextField();
		xmax_tf.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				swf.getHeader().setXmax(Integer.parseInt(xmax_tf.getText())*20);
			}
		});

		ymin_tf = new JTextField();
		ymin_tf.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				swf.getHeader().setYmin(Integer.parseInt(ymin_tf.getText())*20);
			}
		});

		ymax_tf = new JTextField();
		ymax_tf.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				swf.getHeader().setYmax(Integer.parseInt(ymax_tf.getText())*20);
			}
		});

		framecount_tf = new JTextField();
		framecount_tf.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				swf.getHeader().setFrameCount(Integer.parseInt(framecount_tf.getText()));
			}
		});

		framerate_tf = new JTextField();
		framerate_tf.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				swf.getHeader().setFrameRate(Integer.parseInt(framerate_tf.getText()));
			}
		});

		czytajSwf_bt.setEnabled(false);
		czytajSwf_bt.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent arg0) {
				
				 SwingWorker worker = new SwingWorker() {

					 protected Object doInBackground() {
						 headersTags();
						 return null;	
					 }

					 @Override
				      protected void done() {
						 showInfo(SWF.msgs.getString("ok"));
				      }

			        };
				worker.execute();
			}
		});
		
		czytajSwf_bt.setText("Czytaj Tagi");
		czytajSwf_bt.setText(SWF.msgs.getString("readTags"));
		JScrollPane scrollPane;
		scrollPane = new JScrollPane();
		tags_ta = new JTextArea(10,10);
		scrollPane.setViewportView(tags_ta);
		tags_ta.setLineWrap(true);

		JLabel naglowek_l;
		naglowek_l = new JLabel();
		naglowek_l.setText("Nagwek SWF");
		naglowek_l.setText(SWF.msgs.getString("SwfHeader"));
		scrollPane.setViewportView(tags_ta);
		doABC_cb = new JComboBox();
		doABC_cb.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent arg0) {
				Main.choosedTag = (Tag)doABC_cb.getSelectedItem();
			}
		});
		
		
		czytajDoabc_bt.setEnabled(false);
		czytajDoabc_bt.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent arg0) {

				 SwingWorker worker = new SwingWorker() {
					 
					 protected Object doInBackground() {
						 doABC();
						return null;	
						}

					 @Override
				       protected void done() {
				           gw.dispose();
				          // swf.status = Statusy.JEST_PLIK_I_DANE;
				       }

			        };

				worker.execute();

				Runnable r = new Runnable() {
							 
								public void run() {
									try {	
										GUI_wczytywanie dialog = new GUI_wczytywanie();
										getThis().frame.getContentPane().add(dialog);
										dialog.setVisible(true);
										dialog.toFront();
										getThis().setGw(dialog);

									} catch (Exception e) {
										e.printStackTrace();
									}
								}
							};
							r.run();
				
			}
		});
		
		czytajDoabc_bt.setText("Czytaj doABC");
		czytajDoabc_bt.setText(SWF.msgs.getString("readDoABC"));

		JScrollPane scrollPane_2;
		scrollPane_2 = new JScrollPane();

		
		
		scrollPane_2.setViewportView(console_tf);
		console_tf.setText("konsola");
		console_tf.setText(SWF.msgs.getString("consola"));
		
		PrintStream out = new PrintStream( new TextAreaOutputStream( console_tf ) );
		System.setOut( out );
		System.setErr( out );


		odswiez_bt.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent arg0) {
				
				
				SwingWorker worker = new SwingWorker() {

					 protected Object doInBackground() {
						 clear();
						 headersTags();
						 doABC();
						return null;	
						}

					 @Override
				       protected void done() {
				           gw.dispose();  
				       }    
			        };
				worker.execute();
				
				Runnable r = new Runnable() {
							 
								public void run() {
									try {	
										GUI_wczytywanie dialog = new GUI_wczytywanie();
										getThis().frame.getContentPane().add(dialog);
										dialog.setVisible(true);
										dialog.toFront();
										getThis().setGw(dialog);
									} catch (Exception e) {
										e.printStackTrace();
									}
								}
							};
							r.run();
							
			}
				
			
		});
		
		odswiez_bt.setText("Odswie");
		odswiez_bt.setText(SWF.msgs.getString("refresh"));
		
		hexview_bt = new JButton();
		hexview_bt.setEnabled(false);
		
		hexview_bt.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent arg0) {
				EventQueue.invokeLater(new Runnable() {
					public void run() {
						try {
							
							JHexEditor jhe = new JHexEditor(swf.bbuf.array());
							getThis().frame.getContentPane().add(jhe);
							jhe.setVisible(true);
							jhe.toFront();
						} catch (Exception e) {
							e.printStackTrace();
						}
					}
				});
			
				
			}
		});
		hexview_bt.setText("HexView");

		JSplitPane splitPane;
		splitPane = new JSplitPane();
		splitPane.setDividerLocation(400);
		splitPane.setLeftComponent(scrollPane);

		//tree_tv.setLayout(new GridLayout(1, 0));
		tree_tv = new TreeView(swf);
		splitPane.setRightComponent(tree_tv);

		JSplitPane splitPane_1;
		splitPane_1 = new JSplitPane();
		splitPane_1.setDividerLocation(0.9);
		splitPane_1.setOrientation(JSplitPane.VERTICAL_SPLIT);
		splitPane_1.setLeftComponent(splitPane);
		splitPane_1.setRightComponent(scrollPane_2);

		JLabel doabc_l;
		doabc_l = new JLabel();
		doabc_l.setText("DoABC");
		
	 

		
		progressBar = new JProgressBar();
		progressBar.setValue(0);
	    progressBar.setStringPainted(true);

		final GroupLayout groupLayout = new GroupLayout((JComponent) frame.getContentPane());
		groupLayout.setHorizontalGroup(
			groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
				.addGroup(groupLayout.createSequentialGroup()
					.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING)
						.addGroup(groupLayout.createSequentialGroup()
							.addContainerGap()
							.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING)
								.addGroup(groupLayout.createSequentialGroup()
									.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
										.addComponent(framerate_l)
										.addComponent(framecount_l)
										.addComponent(ymax_l)
										.addComponent(ymin_l)
										.addComponent(xmax_l)
										.addComponent(xmin_l)
										.addComponent(wersja_l)
										.addComponent(rozmiar_l))
									.addGap(54, 54, 54)
									.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
										.addComponent(framerate_tf, GroupLayout.PREFERRED_SIZE, 87, GroupLayout.PREFERRED_SIZE)
										.addComponent(framecount_tf, GroupLayout.PREFERRED_SIZE, 87, GroupLayout.PREFERRED_SIZE)
										.addComponent(ymax_tf, GroupLayout.PREFERRED_SIZE, 87, GroupLayout.PREFERRED_SIZE)
										.addComponent(ymin_tf, GroupLayout.PREFERRED_SIZE, 87, GroupLayout.PREFERRED_SIZE)
										.addComponent(xmax_tf, GroupLayout.PREFERRED_SIZE, 87, GroupLayout.PREFERRED_SIZE)
										.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING)
											.addComponent(xmin_tf, GroupLayout.PREFERRED_SIZE, 87, GroupLayout.PREFERRED_SIZE)
											.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
												.addComponent(rozmiar_tf, GroupLayout.PREFERRED_SIZE, 87, GroupLayout.PREFERRED_SIZE)
												.addComponent(wersja_tf, GroupLayout.PREFERRED_SIZE, 87, GroupLayout.PREFERRED_SIZE)))))
								.addGroup(groupLayout.createSequentialGroup()
									.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false)
										.addComponent(czytajDoabc_bt, GroupLayout.Alignment.LEADING, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
										.addComponent(czytajSwf_bt, GroupLayout.Alignment.LEADING, GroupLayout.DEFAULT_SIZE, 138, Short.MAX_VALUE)
										.addComponent(odswiez_bt, GroupLayout.Alignment.LEADING, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
										.addComponent(hexview_bt, GroupLayout.Alignment.LEADING, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
									.addGap(27, 27, 27)))
							.addGap(52, 52, 52)
							.addComponent(splitPane_1, GroupLayout.DEFAULT_SIZE, 689, Short.MAX_VALUE))
						.addGroup(groupLayout.createSequentialGroup()
							.addGap(73, 73, 73)
							.addComponent(naglowek_l)
							.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 299, Short.MAX_VALUE)
							.addComponent(tagi_l, GroupLayout.PREFERRED_SIZE, 36, GroupLayout.PREFERRED_SIZE)
							.addGap(154, 154, 154)
							.addComponent(doabc_l)
							.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
							.addComponent(doABC_cb, GroupLayout.PREFERRED_SIZE, 268, GroupLayout.PREFERRED_SIZE)))
					.addContainerGap())
				.addComponent(progressBar, GroupLayout.DEFAULT_SIZE, 978, Short.MAX_VALUE)
		);
		groupLayout.setVerticalGroup(
			groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
				.addGroup(groupLayout.createSequentialGroup()
					.addContainerGap()
					.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
						.addComponent(naglowek_l)
						.addComponent(tagi_l)
						.addComponent(doABC_cb, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
						.addComponent(doabc_l))
					.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
						.addGroup(groupLayout.createSequentialGroup()
							.addGap(27, 27, 27)
							.addComponent(splitPane_1, GroupLayout.DEFAULT_SIZE, 552, Short.MAX_VALUE))
						.addGroup(groupLayout.createSequentialGroup()
							.addGap(18, 18, 18)
							.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
								.addComponent(wersja_tf, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
								.addComponent(wersja_l))
							.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
							.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
								.addComponent(rozmiar_tf, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
								.addComponent(rozmiar_l))
							.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
							.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
								.addComponent(xmin_l)
								.addComponent(xmin_tf, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
							.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
							.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
								.addComponent(xmax_l)
								.addComponent(xmax_tf, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
							.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
							.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
								.addComponent(ymin_l)
								.addComponent(ymin_tf, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
							.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
							.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
								.addComponent(ymax_l)
								.addComponent(ymax_tf, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
							.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
							.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
								.addComponent(framecount_tf, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
								.addComponent(framecount_l))
							.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
							.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
								.addComponent(framerate_tf, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
								.addComponent(framerate_l))
							.addGap(45, 45, 45)
							.addComponent(czytajSwf_bt)
							.addGap(16, 16, 16)
							.addComponent(czytajDoabc_bt)
							.addGap(18, 18, 18)
							.addComponent(odswiez_bt)
							.addGap(17, 17, 17)
							.addComponent(hexview_bt)))
					.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
					.addComponent(progressBar, GroupLayout.PREFERRED_SIZE, 28, GroupLayout.PREFERRED_SIZE))
		);

		frame.getContentPane().setLayout(groupLayout);
		frame.pack();
		frame.setExtendedState(JFrame.MAXIMIZED_BOTH);  //Maximizing the frame
		
		

	}

	public void setComboBoxDoABC(){
		
		for ( Tag t : SWF.EN_Tag){
			if(t.getopcode()==72 ||t.getopcode()==82 )
				doABC_cb.addItem(t);
		}
	}
	public void clear(){
		doABC_cb.removeAllItems();
		framecount_tf.setText("");
		framerate_tf.setText("");
		tags_ta.setText("");
		rozmiar_tf.setText("");
		wersja_tf.setText("");
		xmax_tf.setText("");
		xmin_tf.setText("");
		ymax_tf.setText("");
		ymin_tf.setText("");
		
	}
	
	public void showError(String warning) {
		JOptionPane.showMessageDialog(null, warning, swf.msgs.getString("error"), JOptionPane.ERROR_MESSAGE);
	}
	
	public void showWarning(String warning) {
		JOptionPane.showMessageDialog(null, warning, SWF.msgs.getString("warning"), JOptionPane.WARNING_MESSAGE);
	}
	
	public void showInfo(String warning) {
		JOptionPane.showMessageDialog(null, warning, SWF.msgs.getString("information"), JOptionPane.INFORMATION_MESSAGE);
	}
	
	public void setFrame(JFrame frame) {
		this.frame = frame;
	}

	public JFrame getFrame() {
		return frame;
	}


	public GUIswfReader getThis()  {
		return this;
	}

	public void setGw(GUI_wczytywanie gw) {
		this.gw = gw;
	}
	
	
	public void headersTags(){
		
		Header header = swf.getSwfHeader();

		if (header.isCompressed()) {
			showWarning(SWF.msgs.getString("WNoDecompressed"));
			
			try {
				swf.dekompresuj();
			} catch (Exception e) {
				e.printStackTrace();
			}
			
			swf.getSwfHeader();
			swf.setHeader(swf.getSwfHeader());	
		}
		header = swf.getSwfHeader();

		wersja_tf.setText(""+header.getVersion());
		
		rozmiar_tf.setText(""+header.getFileLength()); 
	
		xmin_tf.setText(""+header.getXmin()); 
	
		xmax_tf.setText(""+header.getXmax()); 
	
		ymin_tf.setText(""+header.getYmin()); 
	
		ymax_tf.setText(""+header.getYmax()); 
	
		framecount_tf.setText(""+header.getFrameCount()); 
	
		framerate_tf.setText(""+header.getFrameRate());
		
		swf.getSwfTags( progressBar);
		
		tags_ta.setText(swf.printTags());
			
		setComboBoxDoABC();
		
		if (doABC_cb.getItemCount()>0)czytajDoabc_bt.setEnabled(true);
			czytajSwf_bt.setEnabled(false);

		
	}
	public void doABC(){
		tree_tv.refersh();
		tree_tv.updateUI();
		tree_tv.createNodes();
		tree_tv.updateUI();
	}
	
	public int getDoAbcPoz(){
		Integer  poz = (Integer)doABC_cb.getSelectedItem();
		return poz;
		
	}
	public int getDoAbcSize(){
		HashMap<String,Integer>  hm = (HashMap<String,Integer> )doABC_cb.getSelectedItem();
		return (Integer)hm.values().toArray()[1];
		
	}
	
	
	public void refresh(){
		int n = JOptionPane.showConfirmDialog(
			    null,
			    SWF.msgs.getString("QRefresh"),
			    SWF.msgs.getString("question"),
			    JOptionPane.YES_NO_OPTION);

		if (n==JOptionPane.YES_OPTION){
			SwingWorker worker = new SwingWorker() {	
				 protected Object doInBackground() {
					
					 clear();
					 headersTags();
					 doABC(); 
					return null;	
					}
	 
				 @Override
			       protected void done() {
			           gw.dispose();
			       }	 
		            
		        };  	        
			worker.execute();
		}
		
	}
	
	public void showNames(){

			EventQueue.invokeLater(new Runnable() {
				public void run() {
					try {
						AbcFile abc = ((DoABC)Main.choosedTag).getAbcData();
						GUI_names frame = new GUI_names(abc.getConstant_pool());
						getThis().frame.getContentPane().add(frame);
						frame.setVisible(true);
						frame.toFront();

					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			});
		
		
	}
	
	public void showExceptions(final GUI_method_body_info gui_method, final MethodBodyInfo method_body){
		
				EventQueue.invokeLater(new Runnable() {
					public void run() {
						try {
							
							GUI_exception_info frame = new GUI_exception_info(swf,gui_method,method_body);
							getThis().frame.getContentPane().add(frame);
							frame.setVisible(true);
							frame.toFront();

						} catch (Exception e) {
							e.printStackTrace();
						}
					}
				});
			
			
	}
	
	
	
}
